SELECT [CAMPAIGN_CODE], [SOURCE_CODE], '~' + [SOURCE_CODE] AS [Encoded SourceCode],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE()) THEN 1 ELSE 0 END) AS   [Curr Year Instances],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE())-1 THEN 1 ELSE 0 END) AS [1 Year Ago Instances],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE())-2 THEN 1 ELSE 0 END) AS [2 Year Ago Instances],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE())-3 THEN 1 ELSE 0 END) AS [3 Year Ago Instances],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE())-4 THEN 1 ELSE 0 END) AS [4 Year Ago Instances],
       SUM(CASE WHEN YEAR([TRANSACTION_DATE]) = YEAR(GETDATE())-5 THEN 1 ELSE 0 END) AS [5 Year Ago Instances]
  FROM [dbo].[Trans]
 WHERE [SOURCE_CODE] <> '' 
   AND TRANSACTION_TYPE <> 'PAY'
GROUP BY [SOURCE_CODE], [CAMPAIGN_CODE]
ORDER BY [SOURCE_CODE], [CAMPAIGN_CODE];
GO
